clc;
clear;
close all;
Re = 50; % Reynolds number
dp = 0.003; % Particle diameter
D_bed = 0.021; % Bed diameter
R_bed = D_bed / 2.;
bin = 40/140; % bin size
rho = 1000; % Density
mu = 0.001; % Viscosity
% Putting all of the data from different subdomains in one file
str = num2str(Re);
projectdir = "Re" + str;
dinfo = dir(fullfile(projectdir, "PDF_Velocity_"+str+".000000_*.txt")); % Location of the raw data
nfiles = length(dinfo);
filenames = fullfile(projectdir, {dinfo.name});
thisfile = filenames{1};
thisdata = load(thisfile);
[row, column] = size(thisdata);
data = zeros(row, nfiles + 3);
thisfile = filenames{1};
thisdata = load(thisfile);
data(:,1) = thisdata(:,1);
data(:,2) = thisdata(:,2);
for K = 2 : nfiles
    thisfile = filenames{K};
    thisdata = load(thisfile);
    if(size(thisdata)~=0)
        data(:,K+1) = thisdata(:,2);
    end
end
for i = 1:row
    data(i,nfiles+2)=sum(data(i,2:nfiles+1));
end
S=sum(data(:,nfiles+2));
% Calculating the final probability density function
for i = 1:row
    data(i,nfiles+3)=data(i,nfiles+2)/S/bin;
end
% Calculating the area below the graphs which should be equal to 1
avg = 0;
sum = 0;
for i=1:row
    sum = sum + data(i,1)*data(i,nfiles+2);
end
avg = sum/S;
v=(Re*mu)/(rho*dp)
avg = avg*v
porosiry = v/avg
A = trapz(data(:,1), data(:,nfiles+3))